/**
* Script: planets.js
* Written by: Radnen
* Updated: 12/22/2010
**/

/**
* Planet Object:
*  - image: string representation of image associated w/ planet.
*  - name: name of the planet.
*  - x, y: position of the planet in space.
**/
function Planet(image, name, x, y, days)
{
	this.name    = name;
	this.image   = image;
	this.x       = x;
	this.y       = y;
	this.status  = "Friendly";
	this.days    = days;
	this.pop     = "";
	this.w       = Resources.images[this.image].width;
	this.h       = Resources.images[this.image].height;
	this.canLand = true;
	this.quests  = [];
	
	this.xx = 0;
	this.yy = 0;
	
	var entered = false;
	
	this.update = function() {
		this.xx = Camera.x + this.x;
		this.yy = Camera.y + this.y;
		
		Resources.images[this.image].blit(this.xx, this.yy);
		
		if (Cursor.onLeftClick()) {
			if (Cursor.isWithin(this.xx, this.yy, this.w, this.h)) {
				Genesis.setName(this.name, "- "+this.status+" -");
				Genesis.selPlanet = this;
				Cursor.leftClick = false;
			}
		}
	}
	
	this.add = function(obj) {
		for (var i in obj) this[i] = obj[i];
	}
	
	this.generateQuests = function() {
		var i = Utility.random(5);
		while(i--) this.quests[i] = GenerateQuest(this.name);
	}
}

/* PLANET DATA: */

var Planets = ({});

Planets["Earth"] = new Planet("earth", "Earth", 100, 600, 365);
Planets["Earth"].add({
	pop: "10.2 Bil."
});

Planets["Luna"] = new Planet("luna", "Luna", 0, 500, 27);
Planets["Luna"].add({
	pop: "None.",
	status: "Passive",
	canLand: false
});

Planets["Mars"] = new Planet("mars", "Mars", 1200, -200, 687);
Planets["Mars"].add({
	pop: "30.67 Mil."
});

Planets["Argay"] = new Planet("argay", "Argay", -50, 100, 210);
Planets["Argay"].add({
	pop: "356 Mil.",
});

Planets["Carbonos"] = new Planet("carbonos", "Carbonos", -200, -200, 547);
Planets["Carbonos"].add({
	pop: "7.6 Mil.",
	status: "Passive"
});

Planets["Galiant"] = new Planet("argay", "Galiant", -50, 100, 210);
Planets["Galiant"].add({
	pop: "6.52 Bil."
});

Planets["Pinrock"] = new Planet("carbonos", "Pinrock", 500, 200, 547);
Planets["Pinrock"].add({
	pop: "9.5 Mil.",
	status: "Passive"
});

Planets["Guardian"] = new Planet("argay", "Guardian", 0, 0, 1264);
Planets["Guardian"].add({
	pop: "6.5 Bil."
});

Planets["Hades"] = new Planet("hades", "Hades", 0, 0, 412);
Planets["Hades"].add({
	pop: "3.12 Bil."
});

Planets["Platus"] = new Planet("argay", "Platus", 100, 150, 412);
Planets["Platus"].add({
	pop: "3.87 Bil."
});

Planets["Meridian"] = new Planet("meridian", "Meridian", 500, 600, 412);
Planets["Meridian"].add({
	pop: "12 Mil.",
	status: "Passive"
});